﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Data;
using DataAccess;

/// <summary>
/// CCPA
/// </summary>
public class CCPA
{
    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440 constructor
    /// </summary>
	public CCPA()
    {
    }

    /******base tables***************************************************************************/

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  gets clinical program area types dataset
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetCPATypeDS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetCPATypeRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  gets a dataset of all clinical program areas for a region site
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetCPADS(BaseMaster BaseMstr,
                            long lRegionID,
                            long lSiteID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nRegionID", lRegionID);
        plist.AddInputParameter("pi_nSiteID", lSiteID);
        
        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetCPARS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathways for a clinical program area
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lCPAID"></param>
    /// <returns></returns>
    public DataSet GetCPAPWDS(BaseMaster BaseMstr,
                            long lCPAID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nCPAID", lCPAID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetCPAPWRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway events for a pathway
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lPWID"></param>
    /// <returns></returns>
    public DataSet GetPWEventDS(BaseMaster BaseMstr,
                                long lPWID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nPWID", lPWID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPWEventRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  get all event and modules
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lPWID"></param>
    /// <returns></returns>
    public DataSet GetPWEventAndModuleDS(BaseMaster BaseMstr,
                                         long lPWID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nPWID", lPWID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPWEventAndModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all modules for a pathway event
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="lPWID"></param>
    /// <returns></returns>
    public DataSet GetPWEventModuleDS(BaseMaster BaseMstr,
                                      long lPWID,
                                      long lPWEventID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_nPWID", lPWID);
        plist.AddInputParameter("pi_nPWEventID", lPWEventID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPWEventModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /******user tables******************************************************************************/


    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  gets a dataset of users clinical program areas
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <returns></returns>
    public DataSet GetUserCPADS(BaseMaster BaseMstr)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetUserCPARS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /********patient tables**************************************************************************/

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all of a patient's pathway for all clinical program areas
    /// ordered by region, site and clinical program area
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatPWDS(BaseMaster BaseMstr,
                              string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }


    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway events for a specific patient pathway
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lPWID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventDS(BaseMaster BaseMstr,
                                   string strPatientID,
                                   long lPatPWID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWID", lPatPWID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }
      

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway events associated with a patient, ordered by clinical program area
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventDS(BaseMaster BaseMstr,
                                   string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
    
        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

   
    
    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway event modules associated with a patient
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetAllPatPWEventModuleDS(BaseMaster BaseMstr,
                                        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway event modules associated with a patient 
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventModuleDS(BaseMaster BaseMstr,
                                        string strPatientID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  Gets all pathway event modules associated with a patient pathway event
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventModuleDS(BaseMaster BaseMstr,
                                        string strPatientID,
                                        long lPatPWID,
                                        long lPatPWEventID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWID", lPatPWID);
        plist.AddInputParameter("pi_nPatPWEventID", lPatPWEventID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// get all modules for a patient pw id
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lPatPWEventID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventModuleDS(BaseMaster BaseMstr,
                                       string strPatientID,
                                       long lPatPWEventID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWEventID", lPatPWEventID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventModuleRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }



    /// <summary>
    /// US:6677 gets one pathway event by id
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lPatPWEventID"></param>
    /// <returns></returns>
    public DataSet GetPatPWEventByIDDS(BaseMaster BaseMstr,
                                       string strPatientID,
                                       long lPatPWEventID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";

        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWEventID", lPatPWEventID);

        //call sp to get ds
        CDataSet cds = new CDataSet();
        DataSet ds = cds.GetOracleDataSet(BaseMstr.DBConn,
                                           "PCK_CPA.GetPatPWEventRS",
                                            plist,
                                            out lStatusCode,
                                            out strStatusComment);


        if (lStatusCode == 0)
        {
            return ds;
        }
        else
        {
            return null;
        }
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440 US:6677  apply default pathway to patient, return -1 if failed, otherwise patient pathway id
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lPathwayID"></param>
    /// <returns></returns>
    //public bool ApplyDefaultPathway(BaseMaster BaseMstr,
    //                                string strPatientID)
    //{
    //    //status info
    //    long lStatusCode = -1;
    //    string strStatusComment = "";
       

    //    //create a new parameter list with standard params from basemstr
    //    CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
    //                                                      BaseMstr.ClientIP,
    //                                                      BaseMstr.FXUserID);

    //    plist.AddInputParameter( "pi_vPatientID", strPatientID);
    //    plist.AddInputParameter( "pi_nRegionID", BaseMstr.RegionID);
    //    plist.AddInputParameter( "pi_nSiteID", BaseMstr.SiteID);

    //    BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.ApplyDefaultPathway",
    //                                    plist,
    //                                    out lStatusCode,
    //                                    out strStatusComment);

    //    if (lStatusCode == 0)
    //    {
    //        return true;
    //    }

    //    return false;
    //}

    /// <summary>
    /// US:6677 combines PWs specified in strPWIDs into 1 pathway
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="strPWTitle"></param>
    /// <param name="dtBaseline"></param>
    /// <param name="strPWIDs"></param>
    /// <returns></returns>
    public long ApplyPathway(BaseMaster BaseMstr,
                             string strPatientID,
                             string strPWTitle,
                             DateTime dtBaseline,
                             string strPWIDs)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";
        long lPatPWID = 0;


        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_vPWIDs", strPWIDs);
        plist.AddInputParameter("pi_vPWTitle", strPWTitle);
        plist.AddInputParameter("pi_dtBaseline", dtBaseline);
        plist.AddOutputParameter("po_nPatPWID", lPatPWID);
        

        BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.ApplyPathway",
                                        plist,
                                        out lStatusCode,
                                        out strStatusComment);

        if (lStatusCode == 0)
        {
            //get the returned patient pathway id
            CDataParameter param = plist.GetItemByName("po_nPatPWID");
            lPatPWID = param.LongParameterValue;
        }

        return lPatPWID;
    }

    /// <summary>
    /// US:6246 US:6245 US:6438 US:6439 US:6440  
    /// Updates the Patient Pathway Event Module status after instrument is saved
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lRegionID"></param>
    /// <param name="lSiteID"></param>
    /// <param name="lCPAID"></param>
    /// <param name="lPatPWID"></param>
    /// <param name="lPatPWEvtID"></param>
    /// <param name="lMID"></param>
    /// <param name="lIntakeID"></param>
    /// <returns></returns>
    public bool UpdatePatPWEventModule(BaseMaster BaseMstr,
                                        string strPatientID,
                                        long lPWID,
                                        long lPatPWEvtID,
                                        long lMID,
                                        long lIntakeID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPWID", lPWID);
        plist.AddInputParameter("pi_nPatPWEvtID", lPatPWEvtID);
        plist.AddInputParameter("pi_nMID", lMID);
        plist.AddInputParameter("pi_nIntakeID", lIntakeID);

        BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.UpdatePatPWEventModule",
                                        plist,
                                        out lStatusCode,
                                        out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;

        }

        return false;
    }

    public bool UpdatePatPWEventModule(BaseMaster BaseMstr,
                                    string strPatientID,
                                    long lPWID,
                                    long lPatPWEvtID,
                                    long lMID,
                                    long lIntakeID,
                                    long lPwEvtModID)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPWID", lPWID);
        plist.AddInputParameter("pi_nPatPWEvtID", lPatPWEvtID);
        plist.AddInputParameter("pi_nMID", lMID);
        plist.AddInputParameter("pi_nIntakeID", lIntakeID);
        plist.AddInputParameter("pi_nPwEvtModID", lPwEvtModID);

        BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.UpdatePatPWEventModule",
                                        plist,
                                        out lStatusCode,
                                        out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;

        }

        return false;
    }


    /// <summary>
    /// adds instruments to a pathway event
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="strMIDS"></param>
    /// <returns></returns>
    public bool InsertPWEventModules(BaseMaster BaseMstr,
                                     string strPatientID,
                                     long lPatPWEventID,
                                     string strMIDS)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWEventID", lPatPWEventID);        
        plist.AddInputParameter("pi_VMIDS", strMIDS);
     
        BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.InsertPatPWEventModules",
                                        plist,
                                        out lStatusCode,
                                        out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;

        }

        return false;
    }

    /// <summary>
    /// US:6678 insert/update pw event modules
    /// </summary>
    /// <param name="BaseMstr"></param>
    /// <param name="strPatientID"></param>
    /// <param name="lPatPWEventID"></param>
    /// <param name="strMIDS"></param>
    /// <returns></returns>
    public bool UpdatePWEventModules(BaseMaster BaseMstr,
                                     string strPatientID,
                                     long lPatPWEventID,
                                     string strEventTitle,
                                     DateTime dtEventDate,
                                     long lAdjustFuture,
                                     string strMIDS)
    {
        //status info
        long lStatusCode = -1;
        string strStatusComment = "";


        //create a new parameter list with standard params from basemstr
        CDataParameterList plist = new CDataParameterList(BaseMstr.ASPSessionID,
                                                          BaseMstr.ClientIP,
                                                          BaseMstr.FXUserID);

        plist.AddInputParameter("pi_vPatientID", strPatientID);
        plist.AddInputParameter("pi_nPatPWEventID", lPatPWEventID);

        plist.AddInputParameter("pi_vEventTitle", strEventTitle);
        plist.AddInputParameter("pi_dtEventDate", dtEventDate);
        plist.AddInputParameter("pi_nAdjustFuture", lAdjustFuture);
        
        plist.AddInputParameter("pi_VMIDS", strMIDS);

        BaseMstr.DBConn.ExecuteOracleSP("PCK_CPA.UpdatePatPWEventModules",
                                        plist,
                                        out lStatusCode,
                                        out strStatusComment);

        if (lStatusCode == 0)
        {
            return true;

        }

        return false;
    }

}